<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\TrendingOffer;
use Illuminate\Http\Request;

class TrendingOfferController extends Controller
{
    /**
     * Get All Active Trending Offers
     * Returns only the text lines for scrolling display
     * Public endpoint - no authentication required
     */
    public function index()
    {
        $trendingOffers = TrendingOffer::where('is_active', true)
            ->orderBy('order', 'asc')
            ->orderBy('created_at', 'desc')
            ->get(['id', 'text', 'order']);

        // Return just the text lines as an array
        $texts = $trendingOffers->pluck('text')->toArray();

        return response()->json([
            'success' => true,
            'data' => $texts
        ], 200);
    }
}
