<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class WalletController extends Controller
{
    /**
     * Top Up Wallet Balance
     */
    public function topUp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|exists:users,id',
            'amount' => 'required|numeric|min:0.01',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422);
        }

        $user = User::findOrFail($request->user_id);

        if (!$user->is_verified) {
            return response()->json([
                'success' => false,
                'message' => 'User is not verified. Please complete signup first.'
            ], 403);
        }

        // Update wallet balance
        $user->wallet_balance += $request->amount;
        $user->save();

        return response()->json([
            'success' => true,
            'message' => 'Wallet topped up successfully',
            'data' => [
                'user_id' => $user->id,
                'amount_added' => $request->amount,
                'new_balance' => $user->wallet_balance,
            ]
        ], 200);
    }

    /**
     * Get Wallet Balance
     */
    public function getBalance(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|exists:users,id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422);
        }

        $user = User::findOrFail($request->user_id);

        return response()->json([
            'success' => true,
            'data' => [
                'user_id' => $user->id,
                'wallet_balance' => $user->wallet_balance,
            ]
        ], 200);
    }
}
