<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReferralSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'referral_levels',
        'level_commissions',
        'commission_type',
        'signup_bonus',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'referral_levels' => 'integer',
        'level_commissions' => 'array',
        'signup_bonus' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    /**
     * Get the admin who created this setting
     */
    public function admin()
    {
        return $this->belongsTo(\App\Models\Admin::class, 'created_by');
    }

    /**
     * Get commission rate for a specific level
     */
    public function getCommissionForLevel($level)
    {
        $commissions = $this->level_commissions ?? [];
        return $commissions[$level] ?? 0;
    }

    /**
     * Get active settings (singleton)
     */
    public static function getActive()
    {
        return static::where('is_active', true)->first();
    }
}
