<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'path',
        'image',
        'is_coming_soon',
        'cost',
        'created_by',
    ];

    protected $casts = [
        'is_coming_soon' => 'boolean',
        'cost' => 'decimal:2',
    ];

    /**
     * Get the admin who created this service
     */
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }
}
