<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCscFieldsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('csc_id')->unique()->nullable()->after('phone_number');
            $table->string('state')->nullable()->after('csc_id');
        });
        
        // Use raw SQL to make email nullable to avoid installing doctrine/dbal
        \DB::statement("ALTER TABLE `users` CHANGE `email` `email` VARCHAR(255) NULL");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['csc_id', 'state']);
            // We cannot easily revert email to non-nullable without potential data loss or validation issues if nulls were introduced.
            // Leaving it nullable is safer, or we could strictly reverting it if we knew for sure no nulls exist.
            // For now, we will just revert the column additions.
        });
    }
}
