<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class EnsureMissingColumnsInStateUrls extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('state_urls', function (Blueprint $table) {
            if (!Schema::hasColumn('state_urls', 'api_url')) {
                $table->string('api_url')->nullable()->after('url');
            }
            if (!Schema::hasColumn('state_urls', 'username')) {
                $table->string('username')->nullable()->after('url');
            }
            if (!Schema::hasColumn('state_urls', 'password')) {
                $table->string('password')->nullable()->after('username');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('state_urls', function (Blueprint $table) {
            //
        });
    }
}
