<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Offer;
use App\Models\Admin;
use Carbon\Carbon;

class OfferSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get or create an admin user
        $admin = Admin::first();
        if (!$admin) {
            $admin = Admin::create([
                'username' => 'admin',
                'email' => 'admin@alldigtalseva.com',
                'password' => 'admin123',
            ]);
        }

        $adminId = $admin->id;
        $today = Carbon::today();
        $nextMonth = Carbon::today()->addMonth();
        $nextWeek = Carbon::today()->addWeek();

        // Clear existing offers (optional - comment out if you want to keep existing data)
        // Offer::truncate();

        // Service Discount Offers
        Offer::create([
            'title' => '50% Off on All Services',
            'description' => 'Get amazing 50% discount on all digital services. Limited time offer!',
            'image_url' => 'https://via.placeholder.com/800x600/FF6B6B/FFFFFF?text=50%25+OFF',
            'offer_type' => 'service_discount',
            'discount_percentage' => 50.00,
            'discount_amount' => null,
            'cashback_amount' => null,
            'promo_code' => 'SAVE50',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextMonth->toDateString(),
            'link' => 'https://example.com/services',
            'order' => 1,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        Offer::create([
            'title' => '30% Discount on Farmer ID Service',
            'description' => 'Special discount on Farmer ID verification service. Verify your Farmer ID at discounted price.',
            'image_url' => 'https://via.placeholder.com/800x600/4ECDC4/FFFFFF?text=30%25+OFF',
            'offer_type' => 'service_discount',
            'discount_percentage' => 30.00,
            'discount_amount' => null,
            'cashback_amount' => null,
            'promo_code' => 'FARMER30',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextWeek->toDateString(),
            'link' => 'https://example.com/farmer-id',
            'order' => 2,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // Signup Bonus Offers
        Offer::create([
            'title' => 'Welcome Bonus ₹100',
            'description' => 'New users get ₹100 cashback on signup. Start your digital journey with bonus money!',
            'image_url' => 'https://via.placeholder.com/800x600/95E1D3/FFFFFF?text=Welcome+Bonus',
            'offer_type' => 'signup_bonus',
            'discount_percentage' => null,
            'discount_amount' => null,
            'cashback_amount' => 100.00,
            'promo_code' => null,
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextMonth->toDateString(),
            'link' => 'https://example.com/signup',
            'order' => 3,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        Offer::create([
            'title' => 'Signup & Get ₹50 Free',
            'description' => 'Create your account now and receive ₹50 instantly in your wallet.',
            'image_url' => 'https://via.placeholder.com/800x600/F38181/FFFFFF?text=Signup+Bonus',
            'offer_type' => 'signup_bonus',
            'discount_percentage' => null,
            'discount_amount' => null,
            'cashback_amount' => 50.00,
            'promo_code' => 'SIGNUP50',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextWeek->toDateString(),
            'link' => null,
            'order' => 4,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // Referral Bonus Offers
        Offer::create([
            'title' => 'Refer & Earn ₹200',
            'description' => 'Refer your friends and earn ₹200 for each successful referral. Share the benefits!',
            'image_url' => 'https://via.placeholder.com/800x600/AA96DA/FFFFFF?text=Refer+%26+Earn',
            'offer_type' => 'referral_bonus',
            'discount_percentage' => null,
            'discount_amount' => null,
            'cashback_amount' => 200.00,
            'promo_code' => null,
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextMonth->toDateString(),
            'link' => 'https://example.com/referral',
            'order' => 5,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // Cashback Offers
        Offer::create([
            'title' => '10% Cashback on Recharge',
            'description' => 'Recharge your wallet and get 10% cashback. More you recharge, more you save!',
            'image_url' => 'https://via.placeholder.com/800x600/FCBAD3/FFFFFF?text=Cashback',
            'offer_type' => 'cashback',
            'discount_percentage' => null,
            'discount_amount' => null,
            'cashback_amount' => null, // This will be calculated based on recharge amount
            'promo_code' => 'CASHBACK10',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextMonth->toDateString(),
            'link' => 'https://example.com/recharge',
            'order' => 6,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        Offer::create([
            'title' => 'Flat ₹25 Cashback',
            'description' => 'Get flat ₹25 cashback on wallet recharge above ₹500.',
            'image_url' => 'https://via.placeholder.com/800x600/FFD93D/FFFFFF?text=Flat+Cashback',
            'offer_type' => 'cashback',
            'discount_percentage' => null,
            'discount_amount' => null,
            'cashback_amount' => 25.00,
            'promo_code' => 'FLAT25',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextWeek->toDateString(),
            'link' => null,
            'order' => 7,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // General Offers
        Offer::create([
            'title' => 'Festival Special Offer',
            'description' => 'Celebrate festivals with us! Enjoy special discounts and offers on all services.',
            'image_url' => 'https://via.placeholder.com/800x600/6BCB77/FFFFFF?text=Festival+Special',
            'offer_type' => 'general',
            'discount_percentage' => 20.00,
            'discount_amount' => null,
            'cashback_amount' => 50.00,
            'promo_code' => 'FESTIVAL',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextMonth->toDateString(),
            'link' => 'https://example.com/festival',
            'order' => 8,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        Offer::create([
            'title' => 'Weekend Special - 15% Off',
            'description' => 'Weekend special discount! Get 15% off on all services this weekend only.',
            'image_url' => 'https://via.placeholder.com/800x600/FF6B9D/FFFFFF?text=Weekend+Special',
            'offer_type' => 'general',
            'discount_percentage' => 15.00,
            'discount_amount' => null,
            'cashback_amount' => null,
            'promo_code' => 'WEEKEND15',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextWeek->toDateString(),
            'link' => null,
            'order' => 9,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // Fixed Amount Discount Offer
        Offer::create([
            'title' => 'Flat ₹50 Off on Services',
            'description' => 'Get flat ₹50 discount on any service. Use promo code to avail this offer.',
            'image_url' => 'https://via.placeholder.com/800x600/C44569/FFFFFF?text=Flat+Discount',
            'offer_type' => 'service_discount',
            'discount_percentage' => null,
            'discount_amount' => 50.00,
            'cashback_amount' => null,
            'promo_code' => 'FLAT50',
            'valid_from' => $today->toDateString(),
            'valid_to' => $nextMonth->toDateString(),
            'link' => 'https://example.com/services',
            'order' => 10,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // Inactive offer (for testing)
        Offer::create([
            'title' => 'Expired Offer Example',
            'description' => 'This is an inactive offer for testing purposes.',
            'image_url' => 'https://via.placeholder.com/800x600/999999/FFFFFF?text=Inactive',
            'offer_type' => 'general',
            'discount_percentage' => 25.00,
            'discount_amount' => null,
            'cashback_amount' => null,
            'promo_code' => 'EXPIRED',
            'valid_from' => Carbon::today()->subMonth()->toDateString(),
            'valid_to' => Carbon::today()->subWeek()->toDateString(),
            'link' => null,
            'order' => 11,
            'is_active' => false,
            'created_by' => $adminId,
        ]);

        $this->command->info('Successfully seeded ' . Offer::count() . ' offers!');
    }
}
