# BOCW ID Service API Documentation

## Overview

The BOCW ID (Bhandkam Kamgar) Service API allows users to verify their BOCW registration using their Aadhar number. The service:
- Accepts Aadhar number (12 digits)
- Calls external API to verify BOCW registration
- Fetches worker photo from storage
- Deducts service cost (₹25 by default, configurable by admin) from user's wallet
- Returns formatted BOCW details in Marathi
- Tracks all service transactions

**Base URL:** `https://api.alldigtalseva.com/api`

---

## Table of Contents

1. [Verify BOCW ID](#verify-bocw-id)
2. [Check Transaction Status](#check-transaction-status)
3. [Service Transaction History](#service-transaction-history)
4. [Admin Service Management (with Cost)](#admin-service-management-with-cost)
5. [Error Responses](#error-responses)
6. [Testing Examples](#testing-examples)

---

## Verify BOCW ID

Verify BOCW ID using Aadhar number. This will deduct the service cost from user's wallet.

**⚠️ Important:** This API may take time to respond as it calls external APIs. The timeout is set to 3 minutes. Please keep the connection open and wait for the response.

**Endpoint:** `POST /service/bocw-id/verify`

**Headers:**
```
Authorization: Bearer {user_token}
Content-Type: application/json
```

**Request Body:**
```json
{
    "aadhar": "424543553261"
}
```

**Parameters:**
- `aadhar` (required): String, exactly 12 digits. Aadhar number to verify.

**Note:** The response includes a `transaction_id` which you can use to check the status later using the status endpoint if needed.

**Success Response (200):**
```json
{
    "success": true,
    "message": "BOCW ID verified successfully",
    "data": {
        "transaction_id": 1,
        "registration_no": "MH262700002218",
        "name_marathi": "गीता भाषकर निमजे",
        "gender_marathi": "स्त्री",
        "dob": "30/12/1971",
        "mobile": 9623407825,
        "residential_city_marathi": "मोरशी",
        "permanent_district_marathi": "अमरावती",
        "registration_date": "03/06/2023",
        "photo_url": "https://storage.mahabocw.in/getfile/639fc4f7-4e92-4fa6-a0c3-1afd8e08263c.jpg",
        "amount_deducted": 25.00,
        "remaining_balance": 475.00
    }
}
```

**Response Fields:**
- `registration_no`: BOCW registration number
- `name_marathi`: Full name in Marathi (first + middle + last name)
- `gender_marathi`: Gender in Marathi ("स्त्री" for female, "पुरुष" for male)
- `dob`: Date of birth in dd/mm/yyyy format
- `mobile`: Mobile number
- `residential_city_marathi`: Residential city in Marathi
- `permanent_district_marathi`: Permanent district in Marathi
- `registration_date`: Registration date in dd/mm/yyyy format
- `photo_url`: URL to fetch the worker's photo

**Error Responses:**

**400 - Insufficient Balance:**
```json
{
    "success": false,
    "message": "Insufficient wallet balance",
    "data": {
        "required_amount": 25.00,
        "current_balance": 10.00,
        "shortage": 15.00
    }
}
```

**400 - Service Coming Soon:**
```json
{
    "success": false,
    "message": "This service is coming soon."
}
```

**400 - No Registration Found:**
```json
{
    "success": false,
    "message": "No BOCW registration found for this Aadhar number",
    "data": []
}
```

**422 - Validation Error:**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "aadhar": [
            "The aadhar must be 12 digits.",
            "The aadhar format is invalid."
        ]
    }
}
```

---

## Check Transaction Status

Check the status of a BOCW ID verification transaction. Useful if you want to check the status of a previous request or if the initial request timed out.

**Endpoint:** `GET /service/bocw-id/status/{id}`

**Headers:**
```
Authorization: Bearer {user_token}
```

**Parameters:**
- `id` (required): Transaction ID returned from the verify endpoint

**Success Response (200) - Pending:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "status": "pending",
        "amount": 25.00,
        "service": {
            "id": 2,
            "name": "BOCW ID",
            "path": "/user/bocwid"
        },
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:00:00.000000Z"
    }
}
```

**Success Response (200) - Success:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "status": "success",
        "amount": 25.00,
        "service": {
            "id": 2,
            "name": "BOCW ID",
            "path": "/user/bocwid"
        },
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:01:30.000000Z",
        "bocw_data": {
            "registration_no": "MH262700002218",
            "name_marathi": "गीता भाषकर निमजे",
            "gender_marathi": "स्त्री",
            "dob": "30/12/1971",
            "mobile": 9623407825,
            "residential_city_marathi": "मोरशी",
            "permanent_district_marathi": "अमरावती",
            "registration_date": "03/06/2023",
            "photo_url": "https://storage.mahabocw.in/getfile/639fc4f7-4e92-4fa6-a0c3-1afd8e08263c.jpg"
        }
    }
}
```

**Success Response (200) - Failed:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "status": "failed",
        "amount": 25.00,
        "service": {
            "id": 2,
            "name": "BOCW ID",
            "path": "/user/bocwid"
        },
        "error_message": "No BOCW registration found for this Aadhar number",
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:01:30.000000Z"
    }
}
```

**Error Response (404):**
```json
{
    "success": false,
    "message": "Transaction not found"
}
```

---

## Service Transaction History

Get history of all BOCW ID service transactions for the authenticated user.

**Endpoint:** `GET /service/bocw-id/history`

**Headers:**
```
Authorization: Bearer {user_token}
```

**Query Parameters:**
- `page` (optional): Page number for pagination (default: 1)

**Success Response (200):**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 1,
                "user_id": 1,
                "service_id": 2,
                "amount": 25.00,
                "service_type": "bocw_id",
                "request_data": {
                    "aadhar": "424543553261"
                },
                "response_data": {
                    "raw_data": [...],
                    "formatted_data": {
                        "registration_no": "MH262700002218",
                        "name_marathi": "गीता भाषकर निमजे",
                        "gender_marathi": "स्त्री",
                        "dob": "30/12/1971",
                        "mobile": 9623407825,
                        "residential_city_marathi": "मोरशी",
                        "permanent_district_marathi": "अमरावती",
                        "registration_date": "03/06/2023",
                        "photo_url": "https://storage.mahabocw.in/getfile/639fc4f7-4e92-4fa6-a0c3-1afd8e08263c.jpg"
                    }
                },
                "status": "success",
                "error_message": null,
                "created_at": "2025-12-05T12:00:00.000000Z",
                "service": {
                    "id": 2,
                    "name": "BOCW ID",
                    "path": "/user/bocwid"
                }
            }
        ],
        "per_page": 20,
        "total": 1
    }
}
```

---

## Admin Service Management (with Cost)

### Add BOCW ID Service with Cost

**Endpoint:** `POST /api/admin/service`

**Request Body:**
```json
{
    "name": "BOCW ID",
    "path": "/user/bocwid",
    "is_coming_soon": false,
    "cost": 25.00
}
```

**Parameters:**
- `name` (required): Service name
- `path` (required): Service path (must start with `/`, e.g., `/user/bocwid`)
- `is_coming_soon` (optional): Boolean, default: false
- `cost` (optional): Decimal, service cost in rupees. Default: 0.00

**Success Response:**
```json
{
    "success": true,
    "message": "Service added successfully",
    "data": {
        "id": 2,
        "name": "BOCW ID",
        "path": "/user/bocwid",
        "is_coming_soon": false,
        "cost": 25.00,
        "created_by": 1,
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:00:00.000000Z"
    }
}
```

### Update Service Cost

**Endpoint:** `PUT /api/admin/service/{id}`

**Request Body:**
```json
{
    "cost": 30.00
}
```

---

## Error Responses

### 401 Unauthorized
```json
{
    "success": false,
    "message": "Unauthorized. Please login first."
}
```

### 404 Service Not Found
```json
{
    "success": false,
    "message": "BOCW ID service not found. Please contact admin."
}
```

### 500 Server Error
```json
{
    "success": false,
    "message": "An error occurred while verifying BOCW ID. Please try again later.",
    "error": "Connection timeout"
}
```

---

## Testing Examples

### cURL Examples

**1. Verify BOCW ID:**
```bash
curl -X POST "https://api.alldigtalseva.com/api/service/bocw-id/verify" \
  -H "Authorization: Bearer {user_token}" \
  -H "Content-Type: application/json" \
  -d '{
    "aadhar": "424543553261"
  }'
```

**2. Check Transaction Status:**
```bash
curl -X GET "https://api.alldigtalseva.com/api/service/bocw-id/status/1" \
  -H "Authorization: Bearer {user_token}"
```

**3. Get Transaction History:**
```bash
curl -X GET "https://api.alldigtalseva.com/api/service/bocw-id/history" \
  -H "Authorization: Bearer {user_token}"
```

**4. Add BOCW ID Service with Cost (Admin):**
```bash
curl -X POST "https://api.alldigtalseva.com/api/admin/service" \
  -H "Authorization: Bearer {admin_token}" \
  -H "Content-Type: application/json" \
  -d '{
    "name": "BOCW ID",
    "path": "/user/bocwid",
    "is_coming_soon": false,
    "cost": 25.00
  }'
```

---

## Notes

1. **Response Time**: ⚠️ **Important**: The external APIs may take time to respond. The HTTP timeout is set to 3 minutes (180 seconds). Please keep the connection open and wait for the response. If your request times out, you can use the transaction ID to check the status later using the status endpoint.

2. **Service Cost**: The service cost is configurable by admin. If not set, it defaults to ₹25.00 for BOCW ID service.

3. **Wallet Deduction**: The amount is deducted from user's wallet only if:
   - User has sufficient balance
   - External API call is successful
   - BOCW registration data is retrieved successfully

4. **Transaction Tracking**: All service usage is tracked in `service_transactions` table, including:
   - Request parameters
   - Raw response data
   - Formatted response data
   - Status (success/failed/pending)
   - Error messages (if any)

5. **External APIs**: The service calls:
   - `https://iwbms.mahabocw.in/api/bocw-registration/getsearchadDetail` - To get BOCW registration details by Aadhar
   - `https://iwbms.mahabocw.in/api/bocw-registration/getregistrationbybocwidforprofile` - To get photo filename
   - `https://storage.mahabocw.in/getfile/{filename}` - To get the actual photo (URL is returned in response)

6. **Aadhar Validation**: Aadhar number must be exactly 12 digits and contain only numbers.

7. **Service Availability**: The service must exist in the database and must not be marked as "coming soon" for the API to work.

8. **Status Checking**: If your initial request times out or you want to check the status of a previous request, use the status endpoint with the transaction ID returned in the response.

9. **Data Formatting**:
   - Dates are formatted as dd/mm/yyyy
   - Gender is converted to Marathi ("स्त्री" for female, "पुरुष" for male)
   - Name is concatenated from first, middle, and last name in Marathi
   - All address fields are returned in Marathi

10. **Photo URL**: The photo URL is automatically generated from the filename returned by the profile API. If photo fetch fails, the service will continue without the photo URL.

---

## Database Schema

### services (updated)
- `id`: Primary key
- `name`: Service name
- `path`: Service path (unique)
- `is_coming_soon`: Boolean
- `cost`: Decimal (10,2) - Service cost in rupees
- `created_by`: Admin ID (foreign key)
- `timestamps`

### service_transactions
- `id`: Primary key
- `user_id`: User ID (foreign key)
- `service_id`: Service ID (foreign key)
- `amount`: Amount deducted
- `service_type`: Type of service (e.g., "bocw_id")
- `request_data`: JSON - Request parameters
- `response_data`: JSON - API response (includes raw_data and formatted_data)
- `status`: Enum (success, failed, pending)
- `error_message`: Text - Error details if failed
- `timestamps`

---

## Support

For issues or questions, please contact the development team.


